﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WordNetClasses;

namespace WordNetTools
{
    public class AnalysedWord
    {
        private string _word;
        private Wnlib.SynSet _sense;
        private bool? _meaningless;
        private string _pos;

        public string POS
        {
            get { return _pos; }
            set { _pos = value; }
        }

        public bool? Meaningless
        {
            get { return _meaningless; }
            set { _meaningless = value; }
        }

        public Wnlib.SynSet Sense
        {
            get { return _sense; }
            set { _sense = value; }
        }
        //private string _basicWord;

        //public string WordBasicForm
        //{
        //    get { return _basicWord; }
        //    set { _basicWord = value; }
        //}

        public string Word
        {
            get { return _word; }
            set { _word = value; }
        }

        public AnalysedWord(string word)
        {
            _word = word;
            _sense = null;
            _meaningless = null;
            _pos = String.Empty;
        }

        public AnalysedWord(string word, Wnlib.SynSet sense)
        {
            _word = word;
            _sense = sense;
            _meaningless = false;
            _pos = String.Empty;
        }
    }
}
